# Vertec reporting typestub module
#
# used instead the builtin module for static analysis in 
# linter enabled editors (eg VSCode).
#
# 2020 Copyright Vertec AG, Weststrasse 75, CH-8003 Zrich

from datetime import date, datetime
from collections.abc import Callable
from email.mime import image

class Table():
    def __init__(self, context, source=[], fields=[], type_name=""):
        # type(Table): -> Table
        """
        Table
        """
        pass   
    
    def add_row(self, obj=None):
        # type: (object) -> TableRow
        """
        Adds a row to the table. Optionally, the row object can be passed.
        """
        pass  

    def initialize_row(self, context, row):
        # type: (Context, TableRow) -> None
        """
        Initialises the single row object.
        """
        pass

    businessclass: str
    """
    Businessclass of the objects for the evaluation of the data type of fields evaluated via ocl
    """

    fields: list
    """
    List for the declaration of fields that are not calculated directly in the report via OCL.
    """

class TableRow():  
    """
    A row object
    """
    pass    

class SingleRowTable(Table):
    """
    Table which contains only one single row. Used as a parent report table as a frame for list reports. 
    Has no object itself, so OCL expressions cannot be called up in it.
    """
    pass

main_table: Table
"""
Designation of a table as the main table, 
in case this is not clear as it has more than one table without a parent table.
"""

def len(table):
    #type: (Table) -> int
    """
    The number of objects in a table can be determined via len(table).
    """

def before_report(context):
    #type: (Context) -> bool
    """
    Method to execute Python code before the report is executed (for example, to display dialogues and set variables on the context object). 
    If this method exists, it is automatically called first. If the method returns False, the execution of the report is aborted. 
    Otherwise it continues to run (True is the default and does not need to be specified).
    """

class Context():
    currentobject: object 
    """Current object"""
    currentdate: date
    """Current date"""
    optarg: object
    """Optional address argument in reports"""
    project: object
    """Optional project argument for email templates"""
    phase: object
    """Optional phase argument for email templates"""
    opportunity: object
    """Optional opportunity argument for email templates"""
    rootlist: list
    """The list on which the report was executed"""
    container: object
    """The container on which the report was executed"""
    varTable: object
    """Current object of the parent-table. Instead of 'Tablename' use the parents classname, e.g. 'varProject'"""
    varTableList: list
    """All objects of the parent-table. Instead of 'Table' use the parents classname, e.g. 'varProjectList'"""
    table: Table
    """
    In the calculation function of a table field (3rd argument as Python function), a resulting table object 
    is available as context.table. This allows access to an already created table, which enables the creation 
    of a row via context.table.add_row().
    """
    reportdef: object
    """The report definition which is used"""
    
    def get_fieldvalue(self, fieldname):
        # type: (str) -> any
        """Get the value of the passed field"""
        pass  

    def evalocl(self, expression, obj=None):
        # type: (str, object | list) -> any
        """
        Eval OCL on the context. All context-variables are available in the OCL expression. 
        If an object or a list is passed as second argument, the OCL will be evaluated on this object or list.
        """ 
        pass

    def set_image(self, name, image):
        # type: (str, object) -> None
        """Reads an image into a context variable with the passed name."""


calculate_main_table: str | Callable[[Context], Table]
"""
calculate_main_table may be a string or a function. 
A string value will be evaluated as OCL expression and must result in a list. 
The expression is evaluated on the original list of the report. self references the passed root list. 
The root list itself does not know the type of its objects, so this must be specified (.oclAsType(class)).
When calculate_main_table is defined as function, it has a Context argument and should return a Table object.
"""


class TextField:
    def __init__(self, name, calc_function=None):
        # type: (str, str) -> TextField
        """TextField(name, calc_function), create a TextField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclTextField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclTextField
        """
        OclTextField(name, expression), create a OclTextField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class CurrencyField:
    def __init__(self, name, calc_function=None):
        # type: (str, float) -> CurrencyField
        """CurrencyField(name, calc_function), create a CurrencyField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclCurrencyField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclCurrencyField
        """
        OclCurrencyField(name, expression), create a OclCurrencyField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class FloatField:
    def __init__(self, name, calc_function=None):
        # type: (str, float) -> FloatField
        """FloatField(name, calc_function), create a FloatField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclFloatField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclFloatField
        """
        OclFloatField(name, expression), create a OclFloatField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class MinuteField:
    def __init__(self, name, calc_function=None):
        # type: (str, int) -> MinuteField
        """MinuteField(name, calc_function), create a MinuteField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclMinuteField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclMinuteField
        """
        OclMinuteField(name, expression), create a OclMinuteField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class BooleanField:
    def __init__(self, name, calc_function=None):
        # type: (str, bool) -> BooleanField
        """BooleanField(name), create a BooleanField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclBooleanField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclBooleanField
        """
        OclBooleanField(name, expression), create a OclBooleanField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class IntegerField:
    def __init__(self, name, calc_function=None):
        # type: (str, int) -> IntegerField
        """IntegerField(name, calc_function), create a IntegerField whose value can be set in the code or calculated via calc-function."""
        pass     

class OclIntegerField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclIntegerField
        """
        OclIntegerField(name, expression), create a OclIntegerField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass

class DateField:
    def __init__(self, name, calc_function=None):
        # type: (str, date) -> DateField
        """DateField(name), create a DateField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclDateField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclDateField
        """
        OclDateField(name, expression), create a OclDateField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class DateTimeField:
    def __init__(self, name, calc_function=None):
        # type: (str, datetime) -> DateTimeField
        """DateTimeField(name), create a DateTimeField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclDateTimeField:
    def __init__(self, name, expression=None):
        # type: (str, str) -> OclDateTimeField
        """
        OclDateTimeField(name, expression), create a OclDateTimeField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass   

class ImageField:
    def __init__(self, name: str, calc_function: Callable[[Context], bytes] | str = ""):
        """
        ImageField(name, calc_function), create a ImageField whose value can be set in the code or calculated via calc-function.
        Must return an image from the database. Specifying an image path does not work.
        """
        pass 

class OclImageField:
    def __init__(self, name: str, expression: str | None):
        """
        OclImageField(name, expression), create a OclImageField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass

class TableField:
    def __init__(self, name:str, classname: str | type, calc_function: Callable[[Context], Table] | str = ""):
        """TableField(name, classname, calc_function), create a TableField whose value can be set in the code or calculated via calc-function."""
        pass 

class OclTableField:
    def __init__(self, name:str, classname:str, expression:str = ""):
        """
        OclTableField(name, classname, expression), create a OclTableField which calculates its value via expression. 
        If expression is not specified, the name is used as expression.
        """
        pass

        





