# Vertec vtcapp typestub module
#
# used instead the builtin module for static analysis in 
# linter enabled editors (eg VSCode).
#
# 2020 Copyright Vertec AG, Weststrasse 75, CH-8003 Zürich


import datetime
from datetime import date


def selectfromlist(caption, text, col1caption, col2caption, default, list):
    # type: (str, str, str, str, str, list) -> str
    """Shows a list selection dialog with 2 columms"""
    pass


def createobject(classname):
    # type: (str) -> object
    """Creates a business object from classname"""
    pass


def createlist(classname, list):
    # type: (str, list) -> list
    """Creates a business object list from classname with object list as optional parameter"""
    pass


def evalocl(expression, subscriber=None):
    # type: (str, Subscriber) -> object
    """evaluates a global OCL expression"""
    pass


def evaltovariable(obj, ocl, varname, subscriber=None):
    # type: (object, str, str, Subscriber) -> None
    """evaluates an OCL expression and puts result into an OCL variable"""
    pass


def evaloclstring(obj, expStr, subscriber=None):
    # type: (object, str, Subscriber) -> str
    """evaluates OCL expression embedded in a string (delimited by %)"""
    pass


def msgbox(text, buttons=0, title=""):
    # type: (str, int, str) -> int
    """shows a messagebox"""
    pass


def inputbox(caption, prompt, default=""):
    # type: (str, str, str) -> str
    """show an inputbox requesting a string value"""
    pass


def getwithsql(class, where, order, idfilterfield="", objectlist=[]):
    # type: (str, str, str, str, list) -> list
    """gets a list of objects with sql and optional field name and object list for filter indices"""
    pass


def getmemberwithsql(obj, membername, where, order):
    # type: (object, str, str, str) -> list
    """gets a list of objects with sql by following an association role"""
    pass


def getwithsqlbymember(class, member, expression, order=""):
    # type: (str, str, str, str) -> list
    """gets a list of objects with sql, based on an expression for a single member"""
    pass


def showdetailform(obj):
    # type: (object) -> None
    """displays detail form for a vertec object"""
    pass


def currentlogin():
    # type: () -> object
    """returns the currently logged in user in vertec"""
    pass


def updatedatabase():
    """writes changes from the vertec object space to the database"""
    pass


def sqlwhere(where):
    # type: (str) -> str
    """translates an sql where clause containing LIKE string comparisons according to the currently used database server"""
    pass


def sqlwherebetweendate(query, from, to):
    # type: (str, date, date) -> str
    """create a SQL between clause with date literals according to the currently used database server"""
    pass


def sqldateliteral(date):
    # type: (date) -> str
    """sqldateliteral(datevalue), gives a date literal including delimiters according to the currently used database server"""
    pass


def fetchlinkmembers(listArg, memberName):
    # type: (list, str) -> list
    """fetches link-members for a list of objects in one go, returning the combined list of referenced objects."""
    pass


def getpropertyvalue(propname, defvalue=None, subscriber=None):
    # type: (str, object, Subscriber) -> object
    """getpropertyvalue(propertyname, default, subscriber), gets a property value by name. returns defaultvalue is property not found. if no default, ValueError is raised"""
    pass


def setpropertyvalue(name, value):
    # type: (str, object) -> None
    """setpropertyvalue(propertyname, value), sets a property value by name. Raises error if property does not exist."""
    pass


def log(category, level, msg):
    # type: (str, int, str) -> None
    """log(category, level, msg), logs a message to the vertec logging system. Level corresponds to the python logging levels."""
    pass


def beginsystemcontext():
    """
    beginsystemcontext(), enable system context security. must be matched with endsystemcontext() call.
    Legacy Method, consider using the SystemContext object in a 'with' statement instead.
    """
    pass


def endsystemcontext():
    """
    endsystemcontext(), reset system context security.
    Legacy Method, consider using the SystemContext object in a 'with' statement instead.
    """
    pass


def disableevents():
    """
    disableevents(), disable execution of change events.
    Legacy Method, consider using the DisabledEvents object in a 'with' statement instead.
    """
    pass


def enableevents():
    """
    enableevents(), re-enable change events.
    Legacy Method, consider using the DisabledEvents object in a 'with' statement instead.
    """
    pass


def translate(txt, lang):
    # type: (str, str) -> str
    """translate(txt, lang), translates a GUI string into current language or into the language with jargon whose code is specified as an optional parameter"""
    pass


def checkfeature(featurecode):
    # type: (str) -> bool
    """check for a certain license feature"""
    pass


def checkcreate(class):
    # type: (str) -> bool
    """check right to create object of specified class"""
    pass


def versiontointeger(versionstr):
    # type: (str) -> int
    """convert a vertec version number to integer for comparison"""
    pass


def getsysteminfo():
    # type: () -> str
    """get systeminfo text (ini file, loadedobjects) from vertec"""
    pass


def scriptexecute(scripttext, argobject=None):
    # type: (str, object) -> None
    """executes a vb/python scripttext (scripttext as string, optional argobject)"""
    pass


def getobjectbyid(id):
    # type: (int) -> object
    """
	get an object by its id (id as int or string)
	"""
    pass


def currentdate():
    # type: () -> date
    """get actual date as date"""
    pass


def currentdatetime():
    # type: () -> datetime
    """get actual date as datetime"""
    pass


def incmonth(date, integer):
    # type: (date, int) -> date
    """get new date/datetime with month incremented"""
    pass


def incyear(date, integer):
    # type: (date, int) -> date
    """get new date/datetime with year incremented"""
    pass


def incday(date, integer):
    # type: (date, int) -> date
    """get new date/datetime with day incremented"""
    pass


def incminute(datetime, integer):
    # type: (datetime, int) -> datetime
    """get datetime with minute incremented"""
    pass


def firstdayofmonth(date):
    # type: (date) -> date
    """get new date/datetime for first day of month"""
    pass


def lastdayofmonth(date):
    # type: (date) -> date
    """get new date/datetime for last day of month"""
    pass


def firstdayofyear(date):
    # type: (date) -> date
    """get new date/datetime for first day of year"""
    pass


def lastdayofyear(date):
    # type: (date) -> date
    """get new date/datetime for last day of year"""
    pass


def thismonday(datum):
    # type: (date) -> date
    """get new date/datetime for monday of same week"""
    pass


def formatminutes(integer):
    # type: (int) -> str
    """format minutes integer value as time string"""
    pass


def strtominutes(string):
    # type: (str) -> int
    """parse time string to a minutes integer value"""
    pass


def strtodate(string):
    # type: (str) -> datetime
    """convert a string to date, using locale information"""
    pass


def datetostr(date):
    # type: (date) -> str
    """convert a date to string, using locale information"""
    pass


def ocldate(date):
    # type: (date) -> str
    """returns a string with ocl encodedate operator for a given datetime value"""
    pass


def datetostrgerman(date):
    # type: (date) -> str
    """convert a date to string, using german locale information"""
    pass


def generateinvoicenumber():
    # type: () -> str
    """returns a new invoice number"""
    pass


def setresourceplanvalue(bearbeiter, projekt, phase, date, intervalType,
                         value):
    # type: (object, object, object, date, int, object) -> None
    """
	DEPRECATED: use setresourceplanvalue method on Projekt/Phase/Bearbeiter. 
	
	setresourceplanvalue(usr, project, phase, date, interval, value), set resourceplan value for a given date and interval.
	"""
    pass


def executereport(rootObj,
                  optarg,
                  berichtObj,
                  saveAs=None,
                  showDialog=False,
                  unused=False,
                  showApp=True):
    # type: (object, object, object, str, object, bool, bool) -> str
    """executereport(obj, optarg, template, saveAs=None, showDialog=False, unused=False, showApp=True), execute a report based on report definition. returns generated report byte string."""
    pass

    
def executereport2(rootObj,
                  optarg,
                  berichtObj,
                  saveAs=None,
                  showDialog=False,
                  unused=False,
                  showApp=True):
    # type: (object, object, object, str, object, bool, bool) -> tuple
    """executereport2(obj, optarg, template, saveAs=None, showDialog=False, unused=False, showApp=True), execute a report based on report definition and returns a tuple of generated report byte string and created activity object."""
    pass


def executeserverwordreport(rootObj,
                            optarg,
                            templatePath,
                            outputFormat=None,
                            saveAs=None,
                            showDialog=False,
                            showApp=True):
    # type: (object, object, str, str, str, bool, bool) -> None
    """executeserverwordreport(obj, optarg, templatePath, outputFormat=None, saveAs=None, showDialog=False, showApp=True), execute a vertec generated report based on a word template"""
    pass


def executefile(path, arguments):
    # type: (str, str) -> None
    """executefile(filepath, commandarguments), execute a file with the specified arguments on the client"""
    pass


def executefolder(path):
    # type: (str) -> None
    """executefolder(folderpath), open a folder on the client"""
    pass


def executeurl(url):
    # type: (str) -> None
    """executeurl(url), open a url on the client"""
    pass


def showcustomdialog(dialogdefinition, initialvalues):
    # type: (str, dict) -> tuple
    """showcustomdialog(definition, initialvalues), show a custom dialog on the client. returns a tuple of bool (OK/Cancel) and value dictionary."""
    pass


def importconfigset(xmltext):
    # type: (str) -> str
    """importconfigset(xmlString), imports a config set. returns the output of the before- and after import scripts."""
    pass


def sendfile(file, filename, showsavedialog=False, openfile=True):
    # type: (str, str, bool, bool) -> bool
    """sendfile(stream, filePath, showsavedialog=false, openfile=true), sends a file to the client application."""
    pass


def requestfilefromclient(title, path, filter, filename):
    # type: (str, str, str, str) -> tuple
    """requestfilefromclient(dialogTitle, directory, filter, fileName), requests a file from the client application and uploads it to the server. returns a tuploe of file name and content."""
    pass


def processbi(from, to, generator):
    # type: (str, str, str) -> None
    """processbi(from, till, generator), triggers the provided generator to process all of its measures and persist the results."""
    pass


def standardprocessbi():
    """standardprocessbi(), triggers the generators of all active measures to process all of its measures and persist the results."""
    pass

def renewdatabaseindexstatistics():
    """renewdatabaseindexstatistics(), triggers the stored procedure for recalculation of database indexes.'"""
    pass

def rendertemplate(templateString, data=None):
    # type: (str, object) -> str
    """rendertemplate(templateString, data), renders a template string using the provided data. rendered document string"""
    pass


def createoutlookmail(to,
                      subject,
                      body="",
                      cc="",
                      bcc="",
                      attachments=[],
                      show=True,
                      onBehalfOf=""):
    # type: (str, str, str, str, str, list, bool, str) -> None
    """createoutlookmail(to, subject, body, cc=None, bcc=None, attachments=None, show=True, onBehalfOf=None), creates an email from given arguments and opens it in outlook (show=True) or saves it as draft."""
    pass


def registercallback():
    # type: () -> str
    """
    registers a new web callback on the cloud server and returns its state token.
    """
    ...


def querycallback(state):
    # type: (str)-> dict
    """
    query a previously registered callback and return delivered values as json or None if callback has not been made yet.
    """
    ...


def getvertecserveraddress():
    # type: () -> str
    """
    get the vertec server address as configured in the ini file.
    """
    ...


def selectaddress(title="", classname="", filter=""):
    # type: (str, str, str) -> object
    """selectaddress(title="", classname="", filter=""), get a address from the search address dialog"""
    pass


def selectproject(title="", filter=""):
    # type: (str, str) -> object
    """selectproject(title="", filter=""), get a project from the search project dialog"""
    pass


def selectphase(title="", filter=""):
    # type: (str, str) -> object
    """selectphase(title="", filter=""), get a phase from the search phase dialog"""
    pass


def selectobjectintree(title="", entrylist=None, browsefilter="", selectfilter=""):
    # type: (str, list, str, str) -> object
    """selectobjectintree(title="", entrylist=None, browsefilter="", selectfilter=""), get a vertec object from the tree select dialog."""
    pass

	
def getmailattachments(mimeContent):
	# type: (str) -> str
	"""getmailattachments(MimeContent), get a comma delimited list of attachment names from Mime content."""
	pass
	
	
def getmailattachment(mimeContent, Idx):
	# type: (str, int) -> str
	"""getmailattachment(MimeContent, Idx), get a attachment by index from the provided Mime content."""
	pass


def syncpayments():
    """syncpayments(), executes the global payment sync."""
    pass

	
def pdfcombine(doc1, doc2):
	# type: (str, str) -> str
	"""pdfcombine(doc1, doc2), combine two pdf documents."""
	pass
	
	
def pdfextract(doc, pagefrom, pagetill):
	# type: (str, int, int) -> str
	"""pdfextract(doc, pagefrom, pagetill), extract one or multiple sites from pdf document. Pagetill is optional, if not set all pages starting from "pagefrom" to the end of the document will be extracted."""
	pass
	
def pdfpagecount(doc):
	# type: (str) -> int
	"""pdfpagecount(doc), get the page count of the pdf document."""
	pass

def readinvoicedocument(document):
	# type: (str) -> object
	"""readinvoicedocument(document), get a data object with the document data."""
	pass

def msgtomime(msgcontent):
	# type: (str) -> str
	"""convert .msg files to MIME format."""
	pass

def roundcurrency(amount, currency=None):
    # type: (float, object) -> float
    """roundcurrency(amount, currency=None), round the amount taking into account the systemproperty "CurrencyRoundToNearest". Optionally a currency object can be provided to determine the rounding unit."""
    pass

def convertwordtopdf(wordDoc):
	# type: (str) -> str
	"""convertwordtopdf(wordDoc), converts a Word document to a pdf document."""
	pass
	
def sendmail(to,
             subject,
             body,
             fromSender="",
             cc="",
             bcc="",
             attachments=[]):
    # type: (str, str, str, str, str, str, list) -> bool
    """sendmail(to, subject, body, fromSender="", cc="", bcc="", attachments=[]), send an email with the given arguments."""
    pass

def getobjectbyentryid(classname, entryid):
	# type: (str, str) -> object
	"""
	Get an object by its entry id filtered by classname.
	"""
	pass

def getcurrentobject():
    # type: () -> object
    """getcurrentobject()->object, returns the currently selected entry object."""

def extractplaintext(content):
    # type: (str) -> str
    """Extracts the plain text of a file. Possible file types are pdf, docx and eml. Every other type of file results in an empty string."""
    pass 	
	
def bigetdata(source, dimensions, measures, from, till, currency=None):
    # type: (list, list, list, datetime, datetime, object) -> object
    """
    Loads BI data for the provided source objects, dimensions, measures and time frame.
    """
    pass

def indexstatus():
    # type: () -> object
    """Get the current status of the indexer as a dictionary."""
    pass


def indexall(cleanExisting=False):
    # type: () -> None
    """Reindexes all objects in the database for which indexing settings are defined. Use carefully, this operation may take very long. With cleanExisting=True, the existing index with be deleted prior to creating a new one."""
    pass

def indexlist(list):
    # type: (list) -> None
    """Reindexes the objects in the provided list. Only objects for which indexing settings are defined are considered."""
    pass
    

def indexlist(className):
    # type: (string) -> None
    """Reindex all objets of the provided class. Only objecs for which indexing settings are defined are considered."""
    pass

def indexabort():
    # type: () -> None
    """Abort the indexing. """
    pass

def search(searchTerm, language=None, withSuggestions=False, datetimeFrom=None, datetimeto=None):
    # type: (str, str, bool, datetime, datetime) -> list
    """"Perform a full text search on all indexed fields of all indexed objects in the database. Returns a list of business objecs found."""
    pass

class SystemContext(object):
    """
    Use this object in a 'with'-statement for automatic starting and ending of the system context.
    """
    pass

class DisabledEvents(object):
    """
    Use this object in a 'with'-statement for automatic disable and enable events.
    """
    pass

        
