# Vertec vtcbi typestub module
#
# used instead the built-in module for static analysis in 
# linter enabled editors (eg VSCode).
#
# 2024 Copyright Vertec AG, Wengistrasse 7, CH-8004 Zürich
class BiUnit(object):
    """Possible values for a unit of measurement"""
    pass

class Measure(object):
    """BI measure"""
    def __init__(self, name, description="", bi_unit=BiUnit.Amount, is_cutoff_date=False):
        # type(Measure, Any, Any="", Any=BiUnit.Amount, bool=False) -> None
        pass

    def set_value(self, value):
        # type(Measure, Any) -> None
        pass
    
    def __str__(self):
        # type(Measure) -> str
        pass

class Dimension(object):
    """BI dimension"""
    def __init__(self, order, name, role=""):
        # type(Dimension, Any, Any, Any="") -> None
        pass
    
    def set_value(self, value):
        # type(Dimension, Any) -> None
        pass

    def __str__(self):
        # type(Dimension) -> str
        pass

class BiGenerator(object):
    """
    Base class for BI generators developed by users.
    """
    def __init__(self, test_vtcapp=None):
        # type(BiGenerator, Any | None = None) -> None
        """Initializes fields for creating an instance of a derived class"""
        pass

    def get_measures(self):
        # type(BiGenerator) -> list
        """Returns the measures of the generator"""
        pass

    def get_dimensions(self):
        # type(BiGenerator) -> list
        """Returns the dimensions of the generator"""
        pass

    def initialize_wrapper(self, startdate, enddate):
        # type(BiGenerator, Any, Any) -> None
        """Called from .NET. Performs initialization for later calculations"""
        pass

    def initialize(self, startdate, enddate):
        # type(BiGenerator, Any, Any) -> None
        """Can be overridden in the generator developed by the user to do any initialization"""
        pass

    def generate_month_wrapper(self, startdate, enddate):
        # type(BiGenerator, Any, Any) -> None
        """Called from .NET to generate values for a month"""
        pass

    def generate_range_wrapper(self, startdate, enddate):
        # type(BiGenerator, Any, Any) -> None
        """Called from .NET to generate values for a period"""
        pass

    def finalize(self):
        # type(BiGenerator) -> None
        """Called from .NET for any finalization"""
        pass

    def store_values(self, currency=None, date=None):
        # type(BiGenerator, Any | None = None, Any | None = None) -> None
        """Called by the derived generator to store the values from the current iteration"""
        pass
    
    def get_values(self):
        # type (BiGenerator) -> str
        """Called from .NET to get the values for the current start date"""
        pass
