# Vertec vtcplanningcore typestub module
#
# used instead the builtin module for static analysis in 
# linter enabled editors (eg VSCode).
#
# 2022 Copyright Vertec AG, Weststrasse 75, CH-8003 Zürich

from datetime import date

def increment_interval_date(date, increment):
    # type(date, int) -> date
    """
    increments a date by the specified amount of resource intervals (day, week, month).
    """
    ...

def show_bulk_planning_dialog(left_obj, right_obj):
    # type: (object, object) -> None
    """
    Shows a dialog to efficiently set multiple planning values for the provided objects.
    The order, in which the objects are provided, does not matter, but the caller needs to ensure
    that one is an object of type AbstractWorker, which means either a Projektbearbeiter or a 
    PlanningWorker, and the other one is either a Projekt or a ProjektPhase.
    """
    ...

def get_planning_level():
    # type: () -> str
    """
    Get the planning level.
    (possible results: 'Projekt' or 'ProjektPhase')
    """
    ...

def get_planning_interval_type():
    # type: () -> str
    """
    Get the planning interval type.
    (possible results: 'day', 'week' or 'month')
    If no planning interval type has been set in system
    settings, an exception will be thrown.
    """
    ...

class ResourcePlanningProvider():

    def __init__(self, source_entries, start_date, end_date):
        # type(list, date, date) -> ResourcePlanningProvider
        """
        Create a resource planning provider.
        Loads all planned values (resource links) belonging to
        the specified sourceEntries for the specified period (start - end).
        """
        ...

    def get_planned_minutes(self, date, source_entry, otherside_entry, subscriber=None):
        # type: (date, object, object, object | None) -> int | None
        """
        Get the planned minutes for the two objects and the date interval.
        Returns None if no plan value is available."""
        ...

    def get_planned_minutes_aggregated(self, source_entry, otherside_entry, date_from, date_to, subscriber=None):
        # type: (object | None, object | None, date, date | None, object | None) -> int | None
        """
        Get the sum of the planned minutes for the provided criteria. If source_entry or otherside_entry is None
        all entries known by this provider will be used. date_from and date_to define the period.
        If no date_to is provided, only the interval defined by date_from is considered.
        """
        ...

    def set_planned_minutes(self, date, source_entry, otherside_entry, value):
        # type: (date, object, object, int | None) -> None
        """
        Sets the planned minutes for the two objects and date interval.
        Pass None to delete the currently planned value.
        """
        ...

    def has_write_access(self, source_entry, otherside_entry, subscriber=None):
        # type: (object, object, object | None) -> bool
        """
        Checks if there is write access for the two objects and the date interval.
        """
        ...
    
    def add_entry(self, entry):
        # type: (object) -> None
        """
        Adds an entry to the list of source entries of the
        planning provider. 
        """
        ...
    
    def add_otherside_entry(self, entry):
        # type: (object) -> None
        """
        Adds a temporary entry to the list of entries 
        with planning data.
        Is used to be able to enter planning data for a new
        combination of source- and otherside entries.
        """
        ...

    def get_otherside_entries(self, subscriber=None):
        # type: (object | None) -> list
        """
        Get all the corresponding entries with planned data in
        the period, based on the source entries of the provider.  
        """
        ...

    def generate_date_range(self, start, end):
        # type: (date, date) -> list[date]
        """
        Returns a list of interval start dates between the given
        start and end date, based on the configured planning interval.
        """
        ...
    
    def get_column_title_by_date(self, date, subscriber=None):
        # type: (date, object | None) -> str
        """
        Get the column title string for a given date, taking into
        account the configured planning interval.
        """
        ...

    def get_start_preceding_interval(self):
        # type: () -> date
        """
        Returns the date of the interval preceding the start interval.
        """
        ...
        
    def get_net_capacity_minutes(self, worker, dateFrom, dateTo=None, subscriber=None):
        # type: (object, date, date | None, object | None) -> int
        """
        Get the net capacity for the specified worker and date range in minutes
        If no dateTo is set, the end date of the matching planning interval for dateFrom will be used as dateTo.
        """
        ...

    def get_custom_net_capacity_minutes(self, worker, dateFrom, dateTo=None, subscriber=None):
        # type: (object, date, date | None, object | None) -> int
        """
        Get the custom net capacity for the specified worker and date range in minutes
        If no dateTo is set, the end date of the matching planning interval for dateFrom will be used as dateTo.
        """
        ...
        
    def get_gross_capacity_minutes(self, worker, dateFrom, dateTo=None, subscriber=None):
        # type: (object, date, date | None, object | None) -> int
        """
        Get the gross capacity for the specified worker and date range in minutes.
        If no dateTo is set, the end date of the matching planning interval for dateFrom will be used as dateTo.
        """
        ...

    def get_remaining_capacity_minutes(self, worker, dateFrom, dateTo=None, subscriber=None):
        # type: (object, date, date | None, object | None) -> int
        """
        Get the remaining free capacity for a specific worker and a specified date range.
        If no dateTo is set, the end date of the matching planning interval for dateFrom will be used as dateTo.
        """
        ...

    def get_custom_remaining_capacity_minutes(self, worker, dateFrom, dateTo=None, subscriber=None):
        # type: (object, date, date | None, object | None) -> int
        """
        Get the custom remaining free capacity for a specific worker and a specified date range.
        If no dateTo is set, the end date of the matching planning interval for dateFrom will be used as dateTo.
        """
        ...
